% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateMinMaxGroup.R
\name{CreateMinMaxGroup}
\alias{CreateMinMaxGroup}
\title{Construct the minimum and maximum for a group of events (phase)}
\usage{
CreateMinMaxGroup(
  data,
  position,
  name = "Phase",
  add = NULL,
  exportFile = NULL
)
}
\arguments{
\item{data}{Data frame containing the output of the MCMC algorithm.}

\item{position}{Numeric vector containing the position of the column
corresponding to the MCMC chains of all dates included in the phase of interest.}

\item{name}{Name of the current group of dates or phase.}

\item{add}{Name of the data frame in which the current minimum and maximum
should be added, default = \code{NULL}.}

\item{exportFile}{Name of the final file that will be saved if chosen,
default = \code{NULL}.}
}
\value{
A data frame containing the minimum and maximum of the group of dates included
in the phase of interest. These values may be appended to a data frame \code{add} if given.
}
\description{
Constructs a data frame containing the output of the MCMC algorithm corresponding to
the minimum and maximum of a group of events
}
\examples{
  data(Events)
  Temp = CreateMinMaxGroup(Events, c(2,4), name = "Phase2")
\dontrun{
  #To do for saving the new variables in csv file
  Temp = CreateMinMaxGroup(Events, c(3,5), name = "Phase1", add=Temp,
 }                          exportFile = "MinMaxPhases.csv")
}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr} and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
