% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiCredibleInterval.R
\name{multi_credible_interval}
\alias{multi_credible_interval}
\title{Bayesian credible interval for a series of dates}
\usage{
multi_credible_interval(data, position, level = 0.95, round_to = 0)
}
\arguments{
\item{data}{data frame containing the output of the MCMC algorithm.}

\item{position}{Numeric vector containing the position of the column
corresponding to the MCMC chains of interest, or a list of column names.}

\item{level}{Probability corresponding to the level of confidence used
for the credible interval.}

\item{round_to}{Integer indicating the number of decimal places.}
}
\value{
Returns a list with the following components:

\describe{
\item{ci}{A data frame with a row for each column in \code{data} and two
columns: \code{inf}, the lower credible interval in calendar years (BC/AD);
and \code{sup}, the upper credible interval in calendar years (BC/AD).}

\item{level}{Probability corresponding to the level of confidence used
for the credible interval.}
\item{call}{The function call.}
}
}
\description{
Estimate the shortest credible interval for each of several
MCMC chains.
}
\details{
A \eqn{(100 * level)}\\% credible interval is an interval
that keeps \eqn{N * (1 -level)} elements of the sample outside the interval.
The \eqn{(100*level)}\\% credible interval is the shortest of the intervals.
}
\examples{
  data(Events)
  multi_credible_interval(Events, c(2, 4, 3), 0.95)
  # round to decade
  multi_credible_interval(Events, c(2, 4, 3), 0.95, -1)

}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr},

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}, and

Thomas S. Dye, \email{tsd@tsdye.online}.
}
