% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/interval.R
\docType{methods}
\name{interval_credible}
\alias{interval_credible}
\alias{interval_credible-method}
\alias{interval_credible,MCMC-method}
\title{Bayesian Credible Interval}
\usage{
interval_credible(x, ...)

\S4method{interval_credible}{MCMC}(
  x,
  level = 0.95,
  calendar = getOption("ArchaeoPhases.calendar")
)
}
\arguments{
\item{x}{An \code{\linkS4class{MCMC}} object containing the output of the MCMC algorithm.}

\item{...}{Currently not used.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.}

\item{calendar}{A \code{\linkS4class{TimeScale}} object specifying the target calendar
(see \code{\link[=calendar]{calendar()}}).}
}
\value{
Returns a \code{\link{list}} of \code{numeric} \code{\link{matrix}}.
}
\description{
Computes the shortest credible interval of the output of the MCMC algorithm
for a single parameter.
}
\details{
A \eqn{(100 \times level)}{(100 * level)} \% credible interval is an interval
that keeps \eqn{N \times (1 - level)}{N * (1 - level)} elements of the
sample outside the interval.

The \eqn{(100 \times level)}{(100 * level)} \% credible interval is the
shortest of all those intervals.

For instance, the 95\% credible interval is the central portion of the
posterior distribution that contains 95\% of the values.
}
\examples{
## Coerce to events
eve <- as_events(mcmc_events, calendar = CE(), iteration = 1)
eve <- eve[1:10000, ]

## Rata die
interval_credible(eve, level = 0.95) # Credible interval
interval_hdr(eve, level = 0.68) # HPD interval

## BP
interval_credible(eve, level = 0.95, calendar = BP()) # Credible interval
interval_hdr(eve, level = 0.95, calendar = BP()) # HPD interval
}
\seealso{
\code{\link[arkhe:interval_credible]{arkhe::interval_credible()}}

Other statistics: 
\code{\link{interval_hdr}()},
\code{\link{sensitivity}()},
\code{\link{summary}()}
}
\author{
A. Philippe, M.-A. Vibet, T. S. Dye, N. Frerebeau
}
\concept{statistics}
