% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tactical_ivy.R
\name{tactical_ivy}
\alias{tactical_ivy}
\title{Returns allocations for the Ivy Portfolio on a given date}
\usage{
tactical_ivy(strat, reb_date, P, R, risk_free = NULL)
}
\arguments{
\item{strat}{A list representing an asset allocation strategy.}

\item{reb_date}{A date on which the allocation rule is applied.}

\item{P}{An xts object with daily prices of the tickers in strat.}

\item{R}{An xts object with daily returns of the tickers in strat.}

\item{risk_free}{Either an xts object with daily returns of the risk-free}
}
\value{
A numeric vector of weights after applying the rule.
}
\description{
\code{tactical_ivy} determines asset allocations for a strategy according to
the Ivy Portfolio rule of Faber (2013,  ISBN:978-1118008850).
}
\details{
The function compares prices at the end of a month to their moving averages.
If the price of an asset is below its moving average, the corresponding
allocation in \code{strat$default_weights} is set to zero.
}
\examples{
ivy  <- asset_allocations$tactical$ivy
reb_date <- as.Date("2022-03-31")
tactical_ivy(ivy, reb_date, ETFs$Prices[, ivy$tickers], ETFs$Returns[, ivy$tickers])
}
