% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitters.R
\name{maxScoreSplit}
\alias{maxScoreSplit}
\title{Bivariate score maximizing splitting}
\usage{
maxScoreSplit(bin, scorer, ties = halfCutTie, pickMax = which.max, ...)
}
\arguments{
\item{bin}{a bin to be split with elements `x`, `y`, `depth`,
`bnds` (list with elements `x` and `y`), `expn`, `n`}

\item{scorer}{function which accepts a numeric vector of potential
split coordinates and the bounds of `bin` and returns a numeric
vector of scores for each}

\item{ties}{function which is called to break ties when all splits
generate the same score}

\item{pickMax}{function which accepts a list of scores and returns
the element of the largest score according to some rule}

\item{...}{optional additional arguments to `scorer`}
}
\value{
A list of two bins resulting from the split of `bin`
along the corresponding margin at the maximum location
}
\description{
A function which splits a bin based on the location
maximizing a score function.
}
\details{
This function serves as a wrapper which manages the
interaction of a score function, marginal splitting functions,
tie breaking function, and a maximum selection function to split
a bin at the observation coordinate which maximizes the score
function.
}
\examples{
bin <- list(x = 1:10, y = sample(1:10),
            bnds = list(x = c(0, 10), y = c(0, 10)),
            expn = 10, n = 10, depth = 0)
maxScoreSplit(bin, chiScores)
maxScoreSplit(bin, miScores) # pretty similar for both
maxScoreSplit(bin, randScores)
maxScoreSplit(bin, randScores) # different every time
}
\author{
Chris Salahub
}
