% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/designAutomation.R
\name{checkPdf}
\alias{checkPdf}
\title{Check the status of a PDF.}
\usage{
checkPdf(source = NULL, destination = NULL, token = NULL)
}
\arguments{
\item{source}{A string. Publicly accessible web address of the input dwg
file.}

\item{destination}{A string. Publicly accessible web address for the output
pdf file.}

\item{token}{A string. Token generated with \code{\link{getToken}} function
with \code{code:all} scope.}
}
\description{
Check the status of a recently created PDF file using the Design Automation
API.
}
\examples{
\dontrun{
mySource <- "http://download.autodesk.com/us/samplefiles/acad/visualization_-_aerial.dwg"
myDestination <- "https://drive.google.com/folderview?id=0BygncDVHf60mTDZVNDltLThLNmM&usp=sharing"
resp <- checkPdf(mySource, myDestination, token = myToken)
resp
}
}
\seealso{
\url{https://developer.autodesk.com/en/docs/design-automation/v2/overview/}
}
