% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_kubernetes_service.R
\docType{class}
\name{aks}
\alias{aks}
\alias{az_kubernetes_service}
\title{Azure Kubernetes Service class}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
aks
}
\description{
Class representing an Azure Kubernetes Service (AKS) resource. For working with the cluster endpoint itself, including deploying images, creating services etc, see \link{kubernetes_cluster}.
}
\section{Methods}{

The following methods are available, in addition to those provided by the \link[AzureRMR:az_resource]{AzureRMR::az_resource} class:
\itemize{
\item \code{new(...)}: Initialize a new AKS object.
\item \code{get_cluster(config, role)}: Return an object representing the Docker registry endpoint.
}
}

\section{Details}{

Initializing a new object of this class can either retrieve an existing AKS resource, or create a new resource on the host. Generally, the best way to initialize an object is via the \code{get_aks}, \code{create_aks} or \code{list_aks} methods of the \link{az_resource_group} class, which handle the details automatically.

Note that this class is separate from the Kubernetes cluster itself. This class exposes methods for working with the Azure resource: updating resource tags, updating and deleting the resource (including updating the Kubernetes version), and so on.

For working with the cluster, including deploying images, services, etc use the object generated with the \code{get_cluster} method. This method takes two optional arguments:
\itemize{
\item \code{config}: The file in which to store the cluster configuration details. By default, this will be located in the AzureR configuration directory if it exists (see \link[AzureAuth:AzureR_dir]{AzureAuth::AzureR_dir}); otherwise, in the R temporary directory. To use the Kubernetes default \code{~/.kube/config} file, set this argument to NULL. Note that any existing file in the given location will be overwritten.
\item \code{role}: This can be \code{"User"} (the default) or \code{"Admin"}.
}
}

\examples{
\dontrun{

# recommended way of retrieving a cluster: via a resource group object
rg <- AzureRMR::az_rm$
    new(tenant="myaadtenant.onmicrosoft.com", app="app_id", password="password")$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

myaks <- rg$get_aks("mycluster")

# sync with Azure: AKS resource creation can take a long time, use this to track status
myaks$sync_fields()

# get the cluster endpoint
kubclus <- myaks$get_cluster()

}
}
\seealso{
\link{create_aks}, \link{get_aks}, \link{delete_aks}, \link{list_aks}, \link[AzureAuth:AzureR_dir]{AzureAuth::AzureR_dir}

\link{kubernetes_cluster} for interacting with the cluster endpoint

\href{https://docs.microsoft.com/en-us/azure/aks/}{AKS documentation} and
\href{https://docs.microsoft.com/en-us/rest/api/aks/}{API reference}
}
\keyword{datasets}
