% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_graph_pager.R
\docType{class}
\name{ms_graph_pager}
\alias{ms_graph_pager}
\title{Pager object for Graph list results}
\format{
An R6 object of class \code{ms_graph_pager}.
}
\description{
Class representing an \emph{iterator} for a set of paged query results.
}
\section{Fields}{

\itemize{
\item \code{token}: The token used to authenticate with the Graph host.
\item \code{output}: What the pager should yield on each iteration, either "data.frame","list" or "object". See 'Value' below.
}
}

\section{Methods}{

\itemize{
\item \code{new(...)}: Initialize a new user object. See 'Initialization' below.
\item \code{has_data()}: Returns TRUE if there are pages remaining in the iterator, or FALSE otherwise.
}
}

\section{Active bindings}{

\itemize{
\item \code{value}: The returned value on each iteration of the pager.
}
}

\section{Initialization}{

The recommended way to create objects of this class is via the \code{ms_object$get_list_pager()} method, but it can also be initialized directly. The arguments to the \code{new()} method are:
\itemize{
\item \code{token}: The token used to authenticate with the Graph host.
\item \code{first_page}: A list containing the first page of results, generally from a call to \code{call_graph_endpoint()} or the \code{do_operation()} method of an AzureGraph R6 object.
\item \verb{next_link_name,value_name}: The names of the components of \code{first_page} containing the link to the next page, and the set of values for the page respectively. The default values are \verb{@odata.nextLink} and \code{value}.
\item \code{generate_objects}: Whether the iterator should return a list containing the parsed JSON for the page values, or convert it into a list of R6 objects. See 'Value' below.
\item \code{type_filter}: Any extra arguments required to initialise the returned objects. Only used if \code{generate_objects} is TRUE.
\item \code{default_generator}: The default generator object to use when converting a list of properties into an R6 object, if the class can't be detected. Defaults to \code{ms_object}. Only used if \code{generate_objects} is TRUE.
\item \code{...}: Any extra arguments required to initialise the returned objects. Only used if \code{generate_objects} is TRUE.
}
}

\section{Value}{

The \code{value} active binding returns the page values for each iteration of the pager. This can take one of 3 forms, based on the initial format of the first page and the \code{generate_objects} argument.

If the first page of results is a data frame (each item has been converted into a row), then the pager will return results as data frames. In this case, the \code{output} field is automatically set to "data.frame" and the \code{generate_objects} initialization argument is ignored. Usually this will be the case when the results are meant to represent external data, eg items in a SharePoint list.

If the first page of results is a list, the \code{generate_objects} argument sets whether to convert the items in each page into R6 objects defined by the AzureGraph class framework. If \code{generate_objects} is TRUE, the \code{output} field is set to "object", and if \code{generate_objects} is FALSE, the \code{output} field is set to "list".
}

\examples{
\dontrun{

# list direct memberships
firstpage <- call_graph_endpoint(token, "me/memberOf")

pager <- ms_graph_pager$new(token, firstpage)
pager$has_data()
pager$value

# once all the pages have been returned
isFALSE(pager$has_data())
is.null(pager$value)

# returning items, 1 per page, as raw lists of properties
firstpage <- call_graph_endpoint(token, "me/memberOf", options=list(`$top`=1))
pager <- ms_graph_pager$new(token, firstpage, generate_objects=FALSE)
lst <- NULL
while(pager$has_data())
    lst <- c(lst, pager$value)

# returning items as a data frame
firstdf <- call_graph_endpoint(token, "me/memberOf", options=list(`$top`=1),
                               simplify=TRUE)
pager <- ms_graph_pager$new(token, firstdf)
df <- NULL
while(pager$has_data())
    df <- vctrs::vec_rbin(df, pager$value)

}
}
\seealso{
\link{ms_object}, \link{extract_list_values}

\href{https://docs.microsoft.com/en-us/graph/overview}{Microsoft Graph overview},
\href{https://docs.microsoft.com/en-us/graph/paging}{Paging documentation}
}
