% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_device.R
\docType{class}
\name{az_device}
\alias{az_device}
\title{Device in Azure Active Directory}
\format{
An R6 object of class \code{az_device}, inheriting from \code{az_object}.
}
\description{
Class representing a registered device.
}
\section{Fields}{

\itemize{
\item \code{token}: The token used to authenticate with the Graph host.
\item \code{tenant}: The Azure Active Directory tenant for this group.
\item \code{type}: always "device" for a device object.
\item \code{properties}: The device properties.
}
}

\section{Methods}{

\itemize{
\item \code{new(...)}: Initialize a new device object. Do not call this directly; see 'Initialization' below.
\item \code{delete(confirm=TRUE)}: Delete a device. By default, ask for confirmation first.
\item \code{update(...)}: Update the device information in Azure Active Directory.
\item \code{do_operation(...)}: Carry out an arbitrary operation on the device.
\item \code{sync_fields()}: Synchronise the R object with the app data in Azure Active Directory.
}
}

\section{Initialization}{

Create objects of this class via the \code{list_registered_devices()} and \code{list_owned_devices()} methods of the \code{az_user} class.
}

\seealso{
\link{ms_graph}, \link{az_user}, \link{az_object}

\href{https://docs.microsoft.com/en-us/graph/overview}{Microsoft Graph overview},
\href{https://docs.microsoft.com/en-us/graph/api/overview?view=graph-rest-1.0}{REST API reference}
}
