% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_methods.R
\name{delete_key_vault}
\alias{delete_key_vault}
\title{Delete an Azure Key Vault}
\description{
Method for the \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} class.
}
\section{Usage}{
\preformatted{delete_key_vault(name, confirm=TRUE, wait=FALSE)
}
}

\section{Arguments}{

\itemize{
\item \code{name}: The name of the key vault.
\item \code{confirm}: Whether to ask for confirmation before deleting.
\item \code{wait}: Whether to wait until the deletion is complete.
}
}

\section{Value}{

NULL on successful deletion.
}

\examples{
\dontrun{

rg <- AzureRMR::get_azure_login()$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

rg$delete_key_vault("mykeyvault")

}
}
\seealso{
\link{create_key_vault}, \link{get_key_vault}, \link{az_key_vault},

\href{https://docs.microsoft.com/en-us/azure/key-vault/}{Azure Key Vault documentation},
\href{https://docs.microsoft.com/en-us/rest/api/keyvault}{Azure Key Vault API reference}
}
