% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vault_endpoint.R
\name{key_vault}
\alias{key_vault}
\title{Azure Key Vault client}
\usage{
key_vault(url, tenant = "common", app = .az_cli_app_id, ...,
  domain = "vault.azure.net", token = NULL)
}
\arguments{
\item{url}{The location of the vault. This can be a full URL, or the vault name alone; in the latter case, the \code{domain} argument is appended to obtain the URL.}

\item{tenant, app, ...}{Authentication arguments that will be passed to \link[AzureAuth:get_azure_token]{AzureAuth::get_azure_token}. The default is to authenticate interactively.}

\item{domain}{The domain of the vault; for the public Azure cloud, this is \code{vault.azure.net}. Also the resource for OAuth authentication.}

\item{token}{An OAuth token obtained via \link[AzureAuth:get_azure_token]{AzureAuth::get_azure_token}. If provided, this overrides the other authentication arguments.}
}
\description{
Azure Key Vault client
}
\details{
This function creates a new Key Vault client object. It includes the following component objects for working with data in the vault:
\itemize{
\item \code{keys}: A sub-object for working with encryption keys stored in the vault. See \link{keys}.
\item \code{secrets}: A sub-object for working with secrets stored in the vault. See \link{secrets}.
\item \code{certificates}: A sub-object for working with certificates stored in the vault. See \link{certificates}.
\item \code{storage}: A sub-object for working with storage accounts managed by the vault. See \link{storage}.
}
}
\examples{
\dontrun{

key_vault("mykeyvault")
key_vault("https://mykeyvault.vault.azure.net")

# authenticating as a service principal
key_vault("mykeyvault", tenant="myaadtenant", app="app_id", password="password")

# authenticating with an existing token
token <- AzureAuth::get_azure_token("https://vault.azure.net", "myaadtenant",
                                    app="app_id", password="password")
key_vault("mykeyvault", token=token)

}
}
\seealso{
\link{keys}, \link{secrets}, \link{certificates}, \link{storage}

\href{https://docs.microsoft.com/en-us/azure/key-vault/}{Azure Key Vault documentation},
\href{https://docs.microsoft.com/en-us/rest/api/keyvault}{Azure Key Vault API reference}
}
