% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl.R
\name{summarise.tbl_kusto_abstract}
\alias{summarise.tbl_kusto_abstract}
\title{Summarise method for Kusto tables}
\usage{
\method{summarise}{tbl_kusto_abstract}(
  .data,
  ...,
  .strategy = NULL,
  .shufflekeys = NULL,
  .num_partitions = NULL
)
}
\arguments{
\item{.data}{A Kusto tbl.}

\item{...}{Summarise expressions.}

\item{.strategy}{A summarise strategy to pass to Kusto. Currently the only value supported is "shuffle".}

\item{.shufflekeys}{A character vector of column names to use as shuffle keys.}

\item{.num_partitions}{The number of partitions for a shuffle query.}
}
\description{
This method is the same as other summarise methods, with the exception of the \code{.strategy}, \code{.shufflekeys} and \code{.num_partitions} optional arguments. They provide hints to the Kusto engine on how to execute the summarisation, and can sometimes be useful to speed up a query. See the Kusto documentation for more details.
}
\examples{
\dontrun{

tbl1 <- tbl_kusto(db, "table1")

## standard dplyr syntax:
summarise(tbl1, mx=mean(x))

## Kusto extensions:
summarise(tbl1, mx=mean(x), .strategy="broadcast") # a broadcast summarise

summarise(tbl1, mx=mean(x), .shufflekeys=c("var1", "var2")) # shuffle summarise with shuffle keys

summarise(tbl1, mx=mean(x), .num_partitions=5)     # no. of partitions for a shuffle summarise
}

}
\seealso{
\link[dplyr:summarise]{dplyr::summarise}
}
