% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/discover.R
\name{getWebServices}
\alias{getWebServices}
\title{Get Available Web Services.}
\usage{
getWebServices(wkID, authToken, url = prodURL)
}
\arguments{
\item{wkID}{workspace ID}

\item{authToken}{primary authorization token}

\item{url}{the API url to make the call to, by default hits the Azure management API}
}
\value{
Returns a list of lists, where each web service is represented as a nested named list with the following fields:

\itemize{
  \item Id
  \item Name
  \item Description
  \item CreationTime
  \item WorkspaceId
  \item DefaultEndpointName
}
}
\description{
Get a list of webservices available to the Microsoft Azure Machine Learning workspace specified by the Azure ML workspace ID.
}
\examples{
\dontrun{
services = getWebServices("wsID", "authToken")
serviceID = services[[1]]["Id"]
}
}
\seealso{
\code{\link{publishWebService}} \code{\link{consumeLists}}

Other discovery functions: \code{\link{discoverSchema}};
  \code{\link{getEPDetails}}; \code{\link{getEndpoints}};
  \code{\link{getFramework}}; \code{\link{getWSDetails}}
}

