% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspace.R
\name{experiments}
\alias{experiments}
\title{List experiments in an AzureML workspace.}
\usage{
experiments(ws, filter = c("all", "my experiments", "samples"))
}
\arguments{
\item{ws}{An AzureML workspace reference returned by \code{\link{workspace}}.}

\item{filter}{Optionally filter result, returing all, mine, or sample datasets.}
}
\value{
A data.frame with class \code{Experiments} listing available experiments in the workspace.
}
\description{
List experiments in an AzureML workspace, optionally filtering on sample or my experiments.
}
\note{
\code{experiments(w)} is equivalent to \code{w$experiments}. Since \code{w$experiments} is simply an R data.frame, you can alternatively filter on any variable as desired.
}
\examples{
\dontrun{
  library(AzureML)
  
  experiment <- "dd01c7e4a424432c9a9f83142d5cfec4.f-id.d2f351dd4cec4c06a4592ac83f7af55a"
  node_id <- '2a472ae1-ecb1-4f40-ae4e-cd3cecb1003f-268'
  
  ws <- workspace()
  
  ws$experiments
  experiments(ws)
  frame <- download.intermediate.dataset(ws, experiment, node_id,
                                         port_name = "Results dataset", 
                                         data_type_id = "GenericCSV")
  head(frame)
}
}
\seealso{
\code{\link{workspace}}, \code{\link{datasets}}, \code{\link{download.intermediate.dataset}}

Other experiment functions: \code{\link{download.intermediate.dataset}},
  \code{\link{workspace}}
}
