% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool.R
\name{init_pool}
\alias{init_pool}
\alias{delete_pool}
\title{Parallelise multiple file transfers in the background}
\usage{
init_pool(max_concurrent_transfers = 10, restart = FALSE, ...)

delete_pool()
}
\arguments{
\item{max_concurrent_transfers}{The maximum number of concurrent file transfers to support, which translates into the number of background R processes to create. Each concurrent transfer requires a separate R process, so limit this is you are low on memory.}

\item{restart}{For \code{init_pool}, whether to terminate an already running pool first.}

\item{...}{Other arguments passed on to \code{parallel::makeCluster}.}
}
\description{
Parallelise multiple file transfers in the background
}
\details{
AzureStor can parallelise file transfers by utilizing a pool of R processes in the background. This often leads to significant speedups when transferring multiple small files. The pool is created by calling \code{init_pool}, or automatically the first time that a multiple file transfer is begun. It remains persistent for the session or until terminated by \code{delete_pool}.

If \code{init_pool} is called and the current pool is smaller than \code{max_concurrent_transfers}, it is resized.
}
\seealso{
\link{multiupload_blob}, \link{multidownload_blob}, \link[parallel:makeCluster]{parallel::makeCluster}
}
