% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_methods.R
\docType{class}
\name{delete_vm}
\alias{delete_vm}
\alias{delete_vm_scaleset}
\title{Delete virtual machine}
\description{
Method for the \link[AzureRMR:az_subscription]{AzureRMR::az_subscription} and \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} classes.
}
\section{Usage}{
\preformatted{## R6 method for class 'az_resource_group'
delete_vm(name, confirm = TRUE, free_resources = TRUE)

## R6 method for class 'az_subscription'
delete_vm(name, confirm = TRUE, free_resources = TRUE,
          resource_group = name)

## R6 method for class 'az_resource_group'
delete_vm_scaleset(name, confirm = TRUE, free_resources = TRUE)

## R6 method for class 'az_subscription'
delete_vm_scaleset(name, confirm = TRUE, free_resources = TRUE,
                  resource_group = name)
}
}

\section{Arguments}{

\itemize{
\item \code{name}: The name of the VM or scaleset.
\item \code{confirm}: Whether to confirm the delete.
\item \code{free_resources}: If this was a deployed template, whether to free all resources created during the deployment process.
\item \code{resource_group}: For the \code{AzureRMR::az_subscription} method, the resource group containing the VM or scaleset.
}
}

\section{Details}{

For the subscription methods, deleting the VM or scaleset will also delete its resource group.
}

\examples{
\dontrun{

sub <- AzureRMR::get_azure_login()$
    get_subscription("subscription_id")

sub$delete_vm("myvm")
sub$delete_vm_scaleset("myscaleset")

}
}
\seealso{
\link{create_vm}, \link{az_vm_template}, \link{az_vm_resource},
\link[AzureRMR:az_subscription]{AzureRMR::az_subscription}, \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group}
}
