% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool.R
\name{init_pool}
\alias{init_pool}
\alias{azure_vm_minpoolsize}
\alias{azure_vm_maxpoolsize}
\alias{delete_pool}
\title{Parallelise operations on VM scaleset instances}
\usage{
init_pool(connections, restart = FALSE, ...)

delete_pool()
}
\arguments{
\item{connections}{The number of concurrent connections to support, which translates into the number of background R processes to create. Each connection requires a separate R process, so limit this is you are low on memory.}

\item{restart}{For \code{init_pool}, whether to terminate an already running pool first.}

\item{...}{Other arguments passed on to \code{parallel::makeCluster}.}
}
\description{
Parallelise operations on VM scaleset instances
}
\details{
AzureVM can parallelise operations on scaleset instances by utilizing a pool of R processes in the background. This can lead to significant speedups when working with scalesets with high instance counts. The pool is created automatically the first time that it is required, or it can be (re)created by calling \code{init_pool} manually. It remains persistent for the session or until terminated by \code{delete_pool}.

If \code{init_pool} is called and the current pool is smaller than \code{connections}, it is resized. The size of the pool can be controlled by the global options \code{azure_vm_minpoolsize} and \code{azure_vm_maxpoolsize}, which have default values of 2 and 10 respectively. To disable parallel operations, set \code{options(azure_vm_maxpoolsize=0)}.

Note that the pool size is unrelated to the \emph{scaleset} size, it only controls how many instances can communicate simultaneously with AzureVM.
}
\seealso{
\link{az_vmss_template}, \link[parallel:makeCluster]{parallel::makeCluster}
}
