% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customvision_predict.R
\name{predict.customvision_model}
\alias{predict.customvision_model}
\alias{predict}
\alias{predict.classification_service}
\alias{predict.object_detection_service}
\title{Get predictions from a Custom Vision model}
\usage{
\method{predict}{customvision_model}(object, images, type = c("class",
  "prob", "list"), ...)

\method{predict}{classification_service}(object, images,
  type = c("class", "prob", "list"), save_result = FALSE, ...)

\method{predict}{object_detection_service}(object, images,
  type = c("class", "prob", "list"), save_result = FALSE, ...)
}
\arguments{
\item{object}{A Custom Vision object from which to get predictions. See 'Details' below.}

\item{images}{The images for which to get predictions.}

\item{type}{The type of prediction: either class membership (the default), the class probabilities, or a list containing all information returned by the prediction endpoint.}

\item{...}{Further arguments passed to lower-level functions; not used.}

\item{save_result}{For the predictive service methods, whether to store the predictions on the server for future use.}
}
\description{
Get predictions from a Custom Vision model
}
\details{
AzureVision defines prediction methods for both Custom Vision model training objects (of class \code{customvision_model}) and prediction services (\code{classification_service} and \code{object_detection_service}). The method for model training objects calls the "quick test" endpoint, and is meant only for testing purposes.

The prediction endpoints accept a single image per request, so supplying multiple images to these functions will call the endpoints multiple times, in sequence. The images can be specified as:
\itemize{
\item A vector of local filenames. All common image file formats are supported.
\item A vector of publicly accessible URLs.
\item A raw vector, or a list of raw vectors, holding the binary contents of the image files.
}
}
\examples{
\dontrun{

# predicting with the training endpoint
endp <- customvision_training_endpoint(url="endpoint_url", key="key")
myproj <- get_project(endp, "myproject")
mod <- get_model(myproj)

predict(mod, "testimage.jpg")
predict(mod, "https://mysite.example.com/testimage.jpg", type="prob")

imgraw <- readBin("testimage.jpg", "raw", file.size("testimage.jpg"))
predict(mod, imgraw, type="list")

# predicting with the prediction endpoint
# you'll need either the project object or the ID
proj_id <- myproj$project$id
pred_endp <- customvision_prediction_endpoint(url="endpoint_url", key="pred_key")
pred_svc <- classification_service(pred_endp, proj_id, "iteration1")
predict(pred_svc, "testimage.jpg")

}
}
\seealso{
\code{\link{train_model}}, \code{\link{publish_model}}, \code{\link{classification_service}}, \code{\link{object_detection_service}}
}
