% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_postprodn_fns.R
\name{fix_label}
\alias{fix_label}
\title{Fix label switching in angmcmc objects}
\usage{
fix_label(object, burnin = 1/3, thin = 1, method = 1)
}
\arguments{
\item{object}{angular MCMC object.}

\item{burnin}{initial fraction of the MCMC samples to be discarded as burn-in. Must be a value in [0, 1).}

\item{thin}{positive integer. If \code{thin =} \eqn{n}, only every \eqn{n}-th realizations of the Markov chain is kept.}

\item{method}{method to use for fixing label switching. Available choices are 1 for \link{dataBased}
and 2 for \link{ecr.iterative.1}.}
}
\value{
Returns another \code{angmcmc} object, with the parameter values (after burn-in and thin)
re-ordered according to the resulting permutation from \link{dataBased} or \link{ecr.iterative.1}.
}
\description{
Fix label switching in angmcmc objects
}
\details{
\code{fix_label} is a wrapper for \link{dataBased} or \link{ecr.iterative.1} (depending on
\code{method}) from the \code{label.switching} package for \code{angmcmc} objects.
}
\examples{
# first fit a vmsin mixture model
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             ncores = 1)
# now apply fix_label
fit.vmsin.20.fix <- fix_label(fit.vmsin.20)

}

