% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_wnorm2_fns.R
\name{rwnorm2mix}
\alias{rwnorm2mix}
\alias{dwnorm2mix}
\title{The bivariate Wrapped Normal mixtures}
\usage{
rwnorm2mix(n, kappa1, kappa2, kappa3, mu1, mu2, pmix, ...)

dwnorm2mix(x, kappa1, kappa2, kappa3, mu1, mu2, pmix, int.displ, log = FALSE)
}
\arguments{
\item{n}{number of observations.}

\item{kappa1, kappa2, kappa3}{vectors of concentration parameters; \code{kappa1, kappa2 > 0, kappa3^2 < kappa1*kappa2} for each component.}

\item{mu1, mu2}{vectors of mean parameters.}

\item{pmix}{vector of mixture proportions.}

\item{...}{additional arguments passed to \link{rmvnorm} from package \code{mvtnorm}}

\item{x}{matrix of angles (in radians) where the density is to be evaluated, with each row being a
single bivariate vector of angles.}

\item{int.displ}{integer displacement. The allowed values are 1, 2, 3, 4 and 5. Default is 3.}

\item{log}{logical. Should the log density be returned instead?}
}
\value{
\code{dwnorm2mix} computes the density  and \code{rwnorm2mix} generates random deviates from the mixture density.
}
\description{
The bivariate Wrapped Normal mixtures
}
\details{
All the argument vectors \code{pmix, kappa1, kappa2, kappa3, mu1} and \code{mu2} must be of the same length,
with \eqn{j}-th element corresponding to the \eqn{j}-th component of the mixture distribution.

The bivariate wrapped normal mixture distribution with component size \code{K = \link{length}(pmix)} has density
\deqn{g(x) = \sum p[j] * f(x; \kappa_1[j], \kappa_2[j], \kappa_3[j], \mu_1[j], \mu_2[j])}
where the sum extends over \eqn{j}; \eqn{p[j]; \kappa_1[j], \kappa_2[j], \kappa_3[j]}; and \eqn{\mu_1[j], \mu_2[j]} respectively denote the mixing proportion,
the three concentration parameters and the two mean parameter for the \eqn{j}-th component, \eqn{j = 1, ..., K},
and \eqn{f(. ; \kappa_1, \kappa_2, \kappa_3, \mu_1, \mu_2)} denotes the density function of the wrapped normal distribution
with concentration parameters \eqn{\kappa_1, \kappa_2, \kappa_3} and  mean parameters \eqn{\mu_1, \mu_2}.
}
\examples{
kappa1 <- c(1, 2, 3)
kappa2 <- c(1, 6, 5)
kappa3 <- c(0, 1, 2)
mu1 <- c(1, 2, 5)
mu2 <- c(0, 1, 3)
pmix <- c(0.3, 0.4, 0.3)
x <- diag(2, 2)
n <- 10

# mixture densities calculated at the rows of x
dwnorm2mix(x, kappa1, kappa2, kappa3, mu1, mu2, pmix)

# number of observations generated from the mixture distribution is n
rwnorm2mix(n, kappa1, kappa2, kappa3, mu1, mu2, pmix)

}
