% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.bammdata.R
\name{summary.bammdata}
\alias{summary.bammdata}
\title{Summary of rate shift results from \code{BAMM} analysis}
\usage{
\method{summary}{bammdata}(object, display = 10, print = T, ...)
}
\arguments{
\item{object}{An object of class \code{bammdata}.}

\item{display}{An integer for the number of rows of the posterior to
display.}

\item{print}{Print summary of shift distribution in console window?}

\item{\dots}{Additional arguments (currently unused).}
}
\value{
Returns (invisibly) a dataframe with 2 components:
    \item{shifts}{The number of shifts.}
    \item{prob}{The corresponding posterior probability of a model with a
    given number of rate shifts.}
}
\description{
Summarizes the posterior distribution on the number of
    shifts.
}
\details{
Prints to console the number of posterior samples and the
    posterior distribution on the number of shifts, which is just the
    fraction of samples in the posterior having 0, 1, 2,...n shifts.
}
\examples{
data(whales, events.whales)
ephy <- getEventData(whales, events.whales, nsamples=100)
summary(ephy)
}
\author{
Mike Grundler, Dan Rabosky
}
\references{
\url{http://bamm-project.org}
}
\keyword{models}

