% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finalZ.R
\name{SummaryClassLabel}
\alias{SummaryClassLabel}
\title{{Local FDR method for summarizing class labels}}
\usage{
SummaryClassLabel(net,test.stat,zTrack,method=c("MajorVote","LocfdrControl"),
plot=FALSE,nburn=50,nskip=2,locfdr.alpha=0.2)
}
\arguments{
\item{net}{The adjacent matrix with 0/1 indicating "connected" or "not directly connected}

\item{test.stat}{The observed test statistics. Missing values are represented as NAs.}

\item{zTrack}{The trace for z. It is a num_of_genes by num_of_iterations matrix.}

\item{method}{A char. Either "MajorVote" or "LocfdrControl".}

\item{plot}{Logical. Default=FALSE, means the plot should be drawn.}

\item{nburn}{Default=50.}

\item{nskip}{Default=2}

\item{locfdr.alpha}{Default=0.2}
}
\value{
A vector, where each value is the summarized class label in c(1,2,3) representing "down-regulate", "null", and "up-regulate".
}
\description{
The finalized class label can be either by method "Major vote", or "under local fdr control".
}
\examples{
\dontrun{
data(net)
data(test.stat)
res=FeatureClassFinder(net,test.stat,niter=100,na.action="NN")
classLabelEst=SummaryClassLabel(net,test.stat,res$zTrack,method="MajorVote")
print(table(classLabelEst))
}
}
