% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactions.R
\name{force.heredity.bas}
\alias{force.heredity.bas}
\title{Post processing function to force constraints on interaction inclusion bas BMA objects}
\usage{
force.heredity.bas(object, prior.prob = 0.5)
}
\arguments{
\item{object}{a bas linear model or generalized linear model object}

\item{prior.prob}{prior probability that a term is included conditional on parents being included}
}
\value{
a bas object with updated models, coefficients and summaries obtained removing all models with   zero prior and posterior probabilities.
}
\description{
This function takes the output of a bas object and allows higher order interactions to be included only if their parent lower order interactions terms are in the model, by assigning zero prior probability, and hence posterior probability, to models that do include their respective parents.
Currently only supports a common Bernoulli prior for inclusion.  Model probabilities are given using the
function `BAS:::prob.heredity`.
}
\note{
Currently prior probabilities are computed using conditional Bernoulli distributions, i.e.  P(gamma_j = 1 | Parents(gamma_j) = 1) = prior.prob.  This is not very efficient for models with a large number of levels.  Future updates will force this at the time of sampling.
}
\examples{
data("chickwts")
bas.chk = bas.lm(weight ~ feed, data=chickwts)
bas.chk.int = force.heredity.bas(bas.chk)


data(Hald)
bas.hald = bas.lm(Y ~ .^2, data=Hald)
bas.hald.int = force.heredity.bas(bas.hald)
image(bas.hald.int)

image(bas.hald.int)


}
\seealso{
Other bas methods: \code{\link{BAS}}, \code{\link{bas.lm}},
  \code{\link{coef.bas}}, \code{\link{confint.coef.bas}},
  \code{\link{confint.pred.bas}},
  \code{\link{diagnostics}}, \code{\link{fitted.bas}},
  \code{\link{image.bas}}, \code{\link{predict.basglm}},
  \code{\link{predict.bas}}, \code{\link{summary.bas}},
  \code{\link{update.bas}}
}
\author{
Merlise A Clyde
}
\keyword{regression}
