% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_matrix.R
\name{list2matrix.which}
\alias{list2matrix.which}
\title{Coerce a BAS list object into a matrix.}
\usage{
list2matrix.which(x, which.models = NULL)
}
\arguments{
\item{x}{a 'bas' object}

\item{which.models}{a vector of indices use to extract a subset}
}
\value{
a matrix representation of \code{x$what}, with number of rows equal
to the length of which.models or total number of models and number of
columns \code{x$n.vars}
}
\description{
Models, coefficients, and standard errors in objects of class 'bas' are
represented as a list of lists to reduce storage by omitting the zero
entries.  These functions coerce the list object to a matrix and fill in the
zeros to facilitate other computations.
}
\details{
\code{list2matrix.bas(x, which)} is equivalent to
\code{list2matrix.which(x)}, however, the latter uses sapply rather than a
loop.
\code{list2matrix.which} and \code{which.matrix} both coerce
\code{x$which} into a matrix.
}
\examples{

data(Hald)
Hald.bic <-  bas.lm(Y ~ ., data=Hald, prior="BIC", initprobs="eplogp")
coef <- list2matrix.bas(Hald.bic, "mle")  # extract all ols coefficients
se <- list2matrix.bas(Hald.bic, "mle.se")
models <- list2matrix.which(Hald.bic)     #matrix of model indicators
models <- which.matrix(Hald.bic$which, Hald.bic$n.vars)     #matrix of model indicators

}
\seealso{
\code{\link{bas}}

Other as.matrix methods: \code{\link{list2matrix.bas}},
  \code{\link{which.matrix}}
}
\author{
Merlise Clyde \email{clyde@duke.edu}
}
\concept{as.matrix methods}
\keyword{regression}
