% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{tree.build}
\alias{tree.build}
\title{Build functional tree.}
\usage{
tree.build(trait, convert = NULL, weight = NULL)
}
\arguments{
\item{trait}{A species x traits matrix or data.frame.}

\item{convert}{A vector of column numbers, usually categorical variables, to be converted to dummy variables.}

\item{weight}{A vector of column numbers with weights for each variable. Its length must be equal to the number of columns in trait.}
}
\value{
An hclust object representing a functional tree.
}
\description{
Builds a functional tree from trait data.
}
\details{
The tree will be built using UPGMA over gower distances (Pavoine et al. 2009) after traits are dummyfied (if needed) and standardized (always).
Gower distance allows continuous, ordinal, categorical or binary variables, with possible weighting.
NAs are allowed as long as each pair of species has at least one trait value in common.
If convert is given the algorithm will convert these column numbers to dummy variables. Otherwise it will convert all columns with factors or characters as values.
}
\examples{
trait = data.frame(body = c(NA,2,3,4,4), beak = c(1,1,1,1,2))
plot(tree.build(trait))
plot(tree.build(trait, weight = c(0, 1)))
}
\references{
Pavoine et al. (2009) On the challenge of treating various types of variables: application for improving the measurement of functional diversity. Oikos, 118: 391-402.
}
