% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_four_factors_plot.R
\name{get_four_factors_plot}
\alias{get_four_factors_plot}
\title{Four factors plot}
\usage{
get_four_factors_plot(df_rank, df_no_rank, team, language)
}
\arguments{
\item{df_rank}{Data frame with the team's offense and 
defense four factors and its ranking labels.}

\item{df_no_rank}{Data frame with the team's offense and 
defense four factors.}

\item{team}{Team name.}

\item{language}{Language labels. Current options are 'en' for english
and 'es' for spanish.}
}
\value{
Graphical device
}
\description{
Once computed the team's factors and its rankings with 
\code{\link{do_four_factors_df}}, this function represents them.
}
\examples{
\dontrun{
df <- do_join_games_bio("ACB", acb_games_1718, acb_players_1718)
df1 <- do_add_adv_stats(df)
team <- "Valencia"
df_four_factors <- do_four_factors_df(df1, team)
# If only one team is represented the ranking between parentheses is just one.
get_four_factors_plot(df_four_factors$df_rank, 
                      df_four_factors$df_no_rank, team, "en")
}

}
\seealso{
\code{\link{do_four_factors_df}}
}
\author{
Guillermo Vinue
}
