% Generated by roxygen2 (4.0.2): do not edit by hand
\name{convertListOfRowsToDataFrame}
\alias{convertListOfRowsToDataFrame}
\title{Convert a list of row-vectors of equal structure to a data.frame.}
\usage{
convertListOfRowsToDataFrame(rows,
  strings.as.factors = default.stringsAsFactors(), row.names, col.names)
}
\arguments{
\item{rows}{[\code{list}]\cr
List of rows. Each row is a list or vector of the same structure.
That means all rows must have the same length and all corresponding elements must have the
same class.}

\item{strings.as.factors}{[\code{logical(1)}]\cr
Convert character columns to factors?
Default is \code{default.stringsAsFactors()}.}

\item{row.names}{[\code{character} | \code{integer} | \code{NULL}]\cr
Row names for result.
By default the names of the list \code{rows} are taken.}

\item{col.names}{[\code{character} | \code{integer}]\cr
Column names for result.
By default the names of an element of \code{rows} are taken.}
}
\value{
[\code{data.frame}].
}
\description{
Elements are arranged in columns according to their name in each
element of \code{rows}. Missing values are filled using NAs.
}
\examples{
convertListOfRowsToDataFrame(list(list(x = 1, y = "a"), list(x = 2, y = "b")))
}

