% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgeomBCD.R
\name{pgeomBCD}
\alias{pgeomBCD}
\title{Cumulative Distribution Function for a Bivariate Geometric Distribution via Conditional Specification}
\usage{
pgeomBCD(x, y, q1, q2, q3)
}
\arguments{
\item{x}{value at which the c.d.f. is evaluated}

\item{y}{value at which the c.d.f. is evaluated}

\item{q1}{probability parameter for \eqn{ X }, in (0, 1]}

\item{q2}{probability parameter for \eqn{ Y }, in (0, 1]}

\item{q3}{dependence parameter, in (0, 1]}
}
\value{
The probability \eqn{ P(X \leq x, Y \leq y) }.
}
\description{
Computes the cumulative distribution function (c.d.f.) of a bivariate geometric conditionals distribution (BGCD) based on Ghosh, Marques, and
Chakraborty (2023).
}
\examples{
# Compute P(X \le 1, Y \le 2) with q1 = 0.5, q2 = 0.6, q3 = 0.8
pgeomBCD(x = 1, y = 2, q1 = 0.5, q2 = 0.6, q3 = 0.8)

# Example with small values
pgeomBCD(x = 0, y = 0, q1 = 0.4, q2 = 0.3, q3 = 0.9)

}
\references{
Ghosh, I., Marques, F., & Chakraborty, S.  (2023) A bivariate geometric distribution via conditional specification: properties and applications, Communications in Statistics - Simulation and Computation, 52:12, 5925--5945, \doi{10.1080/03610918.2021.2004419}
}
\seealso{
\code{\link{dgeomBCD}}
\code{\link{rgeomBCD}}
}
