% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpoisBCD.R
\name{rpoisBCD}
\alias{rpoisBCD}
\title{Random Sampling from a Bivariate Poisson Distribution via Conditional Specification}
\usage{
rpoisBCD(n, lambda1, lambda2, lambda3, seed = 123)
}
\arguments{
\item{n}{number of samples to generate}

\item{lambda1}{rate parameter for \eqn{ X } that must be positive}

\item{lambda2}{rate parameter for \eqn{ Y } that must be positive}

\item{lambda3}{dependence parameter that must be (0, 1]}

\item{seed}{seed for random number generation (default = 123)}
}
\value{
A data frame with columns `X` and `Y`, containing the sampled values.
}
\description{
Generates random samples from a bivariate Poisson distribution (BPD).
}
\examples{
samples <- rpoisBCD(n = 100, lambda1 = 0.5, lambda2 = 0.5, lambda3 = 0.5)
cor(samples$X, samples$Y) # Should be negative

}
