% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.bcea.R
\name{plot.bcea}
\alias{plot.bcea}
\title{Summary Plot of the Health Economic Analysis}
\usage{
\method{plot}{bcea}(
  x,
  comparison = NULL,
  wtp = 25000,
  pos = FALSE,
  graph = c("base", "ggplot2"),
  ...
)
}
\arguments{
\item{x}{A \code{bcea} object containing the results of the Bayesian
modelling and the economic evaluation.}

\item{comparison}{Selects the comparator, in case of more than two
interventions being analysed. Default as NULL plots all the comparisons
together. Any subset of the possible comparisons can be selected (e.g.,
\code{comparison=c(1,3)} or \code{comparison=2}).}

\item{wtp}{The value of the willingness to pay parameter. It is passed to
\code{\link{ceplane.plot}}.}

\item{pos}{Parameter to set the position of the legend (only relevant for
multiple interventions, ie more than 2 interventions being compared).
Can be given in form
of a string \code{(bottom|top)(right|left)} for base graphics and
\code{bottom|top|left|right} for ggplot2. It can be a two-elements vector,
which specifies the relative position on the x and y axis respectively, or
alternatively it can be in form of a logical variable, with \code{FALSE}
indicating to use the default position and \code{TRUE} to place it on the
bottom of the plot.}

\item{graph}{A string used to select the graphical engine to use for
plotting. Should (partial-)match the two options \code{"base"} or
\code{"ggplot2"}. Default value is \code{"base"}.}

\item{...}{Arguments to be passed to the methods \code{\link{ceplane.plot}}
and \code{\link{eib.plot}}. Please see the manual pages for the individual
functions.  Arguments like \code{size}, \code{ICER.size} and \code{plot.cri}
can be supplied to the functions in this way. In addition if
\code{graph="ggplot2"} and the arguments are named theme objects they will
be added to each plot.}
}
\value{
A plot with four graphical summaries of the health economic evaluation.
}
\description{
Plots in a single graph the Cost-Effectiveness plane, the Expected
Incremental Benefit, the CEAC and the EVPI.
}
\details{
The default position of the legend for the cost-effectiveness plane
(produced by \code{\link{ceplane.plot}}) is set to \code{c(1, 1.025)}
overriding its default for \code{pos=FALSE}, since multiple ggplot2 plots
are rendered in a slightly different way than single plots.
}
\examples{
# See Baio G., Dawid A.P. (2011) for a detailed description of the 
# Bayesian model and economic problem

# Load the processed results of the MCMC simulation model
data(Vaccine)

# Runs the health economic evaluation using BCEA
he <- bcea(
       e=eff, c=cost,        # defines the variables of 
                             #  effectiveness and cost
       ref=2,                # selects the 2nd row of (e,c) 
                             #  as containing the reference intervention
       interventions=treats, # defines the labels to be associated 
                             #  with each intervention
       Kmax=50000,           # maximum value possible for the willingness 
                             #  to pay threshold; implies that k is chosen 
                             #  in a grid from the interval (0,Kmax)
       plot=FALSE            # does not produce graphical outputs
      )

# Plots the summary plots for the "bcea" object m using base graphics
plot(he, graph = "base")

# Plots the same summary plots using ggplot2
if(require(ggplot2)){
plot(he, graph = "ggplot2")

##### Example of a customized plot.bcea with ggplot2
plot(he,
  graph = "ggplot2",                                      # use ggplot2
  theme = theme(plot.title=element_text(size=rel(1.25))), # theme elements must have a name
  ICER_size = 1.5,                                        # hidden option in ceplane.plot
  size = rel(2.5)                                         # modifies the size of k = labels
  )                                                       # in ceplane.plot and eib.plot
}

}
\references{
\insertRef{Baio2011}{BCEA}

\insertRef{Baio2013}{BCEA}
}
\seealso{
\code{\link{bcea}},
         \code{\link{ceplane.plot}},
         \code{\link{eib.plot}},
         \code{\link{ceac.plot}},
         \code{\link{evi.plot}}
}
\author{
Gianluca Baio, Andrea Berardi
}
\keyword{hplot}
