% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BCHM.R
\name{BCHM}
\alias{BCHM}
\title{Perform the analysis based on the BCHM design.}
\usage{
BCHM(
  nDat,
  xDat,
  mu = 0.2,
  sigma02 = 10,
  sigmaD2 = 0.001,
  alpha = 1e-60,
  d0 = 0.05,
  alpha1 = 50,
  beta1 = 10,
  tau2 = 0.1,
  phi1 = 0.1,
  deltaT = 0.05,
  thetaT = 0.6,
  burnIn = 10000,
  MCIter = 20000,
  MCNum = 20000,
  seed = 1000
)
}
\arguments{
\item{nDat}{Number of patients in each subgroup.}

\item{xDat}{Number of responses in each subgroup.}

\item{mu}{Hyperprior mean for the cluster.}

\item{sigma02}{Hyperprior variance for the cluster.}

\item{sigmaD2}{Variance of subgroup response rate.}

\item{alpha}{Alpha value of the Dirichlet Process determining number of clusters.}

\item{d0}{Minimum value for the similarity matrix.}

\item{alpha1}{Prior for borrowing strength gamma(alpha1, beta1) in the hierarchical model.}

\item{beta1}{Prior for borrowing strength gamma(alpha1, beta1) in the hierarchical model.}

\item{tau2}{Hyperprior precision parameter of subgroup means in the hierarchical model}

\item{phi1}{The response rate of the standard treatment.}

\item{deltaT}{The expected improvement in the response rate over the standard treatment.}

\item{thetaT}{Threshold value for the inference claiming efficacy.}

\item{burnIn}{Number of burn_in in MCMC.}

\item{MCIter}{Number of MCMC iterations.}

\item{MCNum}{Number of MCMC iterations in the hierarchical model.}

\item{seed}{Random seed.}
}
\value{
The return is a list including three elements: \code{Samples}, \code{SMatrix}, and \code{Result}.

The return list element \code{Samples} is the sampled posterior response rates of all subgroups.

The return list element \code{SMatrix} is the similarity matrix of all subgroups.

The return list element \code{Result} is the calculation results of all subgroups. It has seven columns: the number of responses of each subgroups, the number of patients in each subgroups, the observe response rates of each subgroups, the cluster index of each subgroups, the posterior mean response rates of each subgroups, the probability of Pr(P>Phi1+deltaT) of each subgroups, and the final decision (0: Not rejected the null, 1 Rejected the null). Note: Because a MCMC computation is applied in the clustering calculation, there are many possible clustering configurations. The cluster index in column 4 is the most possible clustering configuration.
}
\description{
The BCHM computation is based on the Bayesian Cluster Hierarchical Model (BCHM) to perform the non-parametric Bayesian clustering and posterior probability calculation with the Bayesian hierarchical model for binary response data in several subgroups. Due to the potential heterogeneity among subgroups, the exchangeability assumption across all subgroups may not hold. A Bayesian non-parametric method is applied to calculate the number of clusters by conducting the multiple cluster classification based on subgroup outcomes. Due to the MCMC sampling, the clustering result is dynamic.  A cluster matrix (Similarity Matrix) is constructed to depict the strength of association between any two subgroups to be classified into the same cluster. The Bayesian hierarchical model is used to compute the posterior probability of treatment effect with the borrowing strength determined by the similarity matrix values calculated from the Bayesian non-parametric clustering.
}
\examples{
nDat = c(25, 25, 25, 25) # total number of patients
xDat = c(2, 3, 8, 6)  # number of responses
alpha <- 1e-20 
d0 <- 0.0 
alpha1 = 50   
beta1 = 10  
tau2 <- 0.1  
phi1 <- 0.1  
deltaT <- 0.2  
thetaT <- 0.60   

res <- BCHM(nDat = nDat,
            xDat = xDat,
            alpha = alpha,
            d0 = d0,             
            alpha1 = alpha1, 
            beta1 = beta1,
            tau2 = tau2,
            phi1 = phi1, 
            deltaT = deltaT,
            thetaT = thetaT,
            burnIn = 100,
            MCIter = 200,
            MCNum = 1000,
            seed = 1000
)
print(res$SMatrix)
print(res$Result)
col <- res$Result[,4]

BCHMplot_cluster(res, col, pch=16)
BCHMplot_post_value(res, col, HPD = 0.8)
BCHMplot_post_dist(res, col, lty=1:length(nDat), lwd =3, xlim=c(0, 0.8))

}
\seealso{
\code{\link{BCHMplot_cluster} Plot the clustering results of subgroups. }

\code{\link{BCHMplot_post_value} Plot the posterior response of subgroups. }

\code{\link{BCHMplot_post_dist} Plot the posterior distributions of subgroups. }
}
