% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{BCHMplot_post_dist}
\alias{BCHMplot_post_dist}
\title{Plot the posterior distributions of subgroups.}
\usage{
BCHMplot_post_dist(
  res,
  col = res$Result[, 4],
  lty = 1:dim(res$Result)[1],
  lwd = 2,
  xlim = c(0, 1),
  ylim = c(0, 20),
  ...
)
}
\arguments{
\item{res}{BCHM calculation results.}

\item{col}{Color vector}

\item{lty}{line types}

\item{lwd}{line width}

\item{xlim}{X-axis range}

\item{ylim}{Y-axis range}

\item{...}{other options}
}
\value{
None
}
\description{
plot the posterior distribution by subgroup ID
}
\examples{
nDat = c(25, 25, 25, 25) # total number of patients
xDat = c(2, 3, 8, 6)  # number of responses
alpha <- 1e-20 
d0 <- 0.0 
alpha1 = 50   
beta1 = 10  
tau2 <- 0.1  
phi1 <- 0.1  
deltaT <- 0.2  
thetaT <- 0.60   

res <- BCHM(nDat = nDat,
            xDat = xDat,
            alpha = alpha,
            d0 = d0,             
            alpha1 = alpha1, 
            beta1 = beta1,
            tau2 = tau2,
            phi1 = phi1, 
            deltaT = deltaT,
            thetaT = thetaT,
            burnIn = 100,
            MCIter = 200,
            MCNum = 1000,
            seed = 1000
)
print(res$SMatrix)
print(res$Result)
col <- res$Result[,4]

BCHMplot_post_dist(res, col, lty=1:length(nDat), lwd =3, xlim=c(0, 0.8))

}
\seealso{
\code{\link{BCHM} Perform the analysis based on the BCHM design.}

\code{\link{BCHMplot_cluster} Plot the clustering results of subgroups. }

\code{\link{BCHMplot_post_value} Plot the posterior response of subgroups. }
}
