% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation_useful_functions.R
\name{plot_changepoint_posterior}
\alias{plot_changepoint_posterior}
\title{Plot the empirical posterior distribution of the change-points.}
\usage{
plot_changepoint_posterior(res, burn)
}
\arguments{
\item{res}{the output obtained from the Metropolis-Hastings algorithms.}

\item{burn}{the proportion of the samples discarded as burn-in.}
}
\value{
returns plot of the empirical posterior of the number of change-points (if the results from the infer_unknown_changepoints function were used).

returns plot of the empirical posterior of the change-points.
}
\description{
This function plots the empirical posterior distribution of the change-points.
}
\examples{
# Use as an example the el_nino dataset.
# Run the function with l_max = 3 change-points, a maximum depth of 5 and the [0, 1] alphabet.
# The sampler is run for 100 iterations

res_unknown <- infer_unknown_changepoints(el_nino, 3, 5, c("01"), 100, fileName = NULL)

# Plot the posterior distribution of the locations and the posterior of the number of change-points.

plot_changepoint_posterior(res_unknown, 0.2)

# This function can be also used with the infer_fixed_changepoints.
# Assume l = 2.

res_fixed <- infer_fixed_changepoints(el_nino, 2, 5, c("01"), 100, fileName = NULL)

# Now, the function will only output the posterior distribution of the change-points 
# (the number is fixed).

plot_changepoint_posterior(res_fixed, 0.2)
}
\seealso{
\code{\link{infer_unknown_changepoints}}, \code{\link{infer_fixed_changepoints}}
}
