% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedCall.R
\name{bedCall}
\alias{bedCall}
\title{Call a function on the BED graph}
\usage{
bedCall(f, ..., bedCheck = FALSE)
}
\arguments{
\item{f}{the function to call}

\item{...}{params for f}

\item{bedCheck}{check if a connection to BED exists (default: FALSE).}
}
\value{
The output of the called function.
}
\description{
Call a function on the BED graph
}
\examples{
\dontrun{
result <- bedCall(
   cypher,
   query=prepCql(
      'MATCH (n:BEID)',
      'WHERE n.value IN $values',
      'RETURN n.value AS value, n.labels, n.database'
   ),
   parameters=list(values=c("10", "100"))
)
}

}
\seealso{
\link{checkBedConn}
}
