% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convDfBeIds.R
\name{convDfBeIds}
\alias{convDfBeIds}
\title{Add BE ID conversion to a data frame}
\usage{
convDfBeIds(df, idCol = NULL, entity = FALSE, ...)
}
\arguments{
\item{df}{the data.frame to be converted}

\item{idCol}{the column in which ID to convert are. If NULL (default)
the row names are taken.}

\item{entity}{if TRUE returns BE instead of BEID (default: FALSE).
BE CAREFUL, THIS INTERNAL ID IS NOT STABLE AND CANNOT BE USED AS A REFERENCE.
This internal identifier is useful to avoid biases related to identifier
redundancy. See \url{../doc/BED.html#3_managing_identifiers}}

\item{...}{params for the \link{convBeIds} function}
}
\value{
A data.frame with converted IDs.
Scope ("be", "source", "organism" and "entity" (see Arguments))
is provided as a named list
in the "scope" attributes: \code{attr(x, "scope")}.
}
\description{
Add BE ID conversion to a data frame
}
\examples{
\dontrun{
toConv <- data.frame(a=1:2, b=3:4)
rownames(toConv) <- c("10", "100")
convDfBeIds(
   df=toConv,
   from="Gene",
   from.source="EntrezGene",
   from.org="human",
   to.source="Ens_gene"
)
}

}
\seealso{
\link{convBeIds}, \link{convBeIdLists}
}
