% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BETS.chart.R
\name{BETS.chart}
\alias{BETS.chart}
\title{Create a chart with a pre-defined BETS series}
\usage{
BETS.chart(alias, lang = "en", out = "png", file = NULL, start = c(2006,
  1), ylim = NULL, open = TRUE)
}
\arguments{
\item{alias}{A \code{character}. The alias of the chart. A complete list of aliases for available charts is under the 'Details' section.}

\item{lang}{A \code{character}. The language. For now, only 'en' (english) is available.}

\item{out}{A \code{character}. The format of the output, that is, the image file. Can be either 'pdf' or 'png'. 'pdf' is a better choice if you need high resolution images.}

\item{file}{A \code{character}. The whole path, including a custom name, for the output (an image file). The default value is 'graphs//parameter_alias' (the 'graphs' directory is under the BETS installation directory).}

\item{start}{A \code{vector}.}

\item{ylim}{A \code{vector}.}

\item{open}{A \code{boolean}.}
}
\value{
If the parameter \code{file} is not set by the user, the chart will be placed in the 'graphs' directory, under the BETS installation directory.
}
\description{
Create a chart with a pre-defined BETS series
}
\details{
\tabular{lll}{
 VALUE \tab DESCRIPTION \tab CODE \cr
 \bold{'ipca_with_core'} \tab National consumer price index (IPCA) - in 12 months and  Broad national consumer price index - Core IPCA trimmed means smoothed \tab 13522 and 4466 \cr
 \bold{'ulc'} \tab Unit labor cost - ULC-US$ - June/1994=100 \tab 11777 \cr
 \bold{'eap'} \tab Economically active population \tab 10810 \cr
 \bold{'cdb'} \tab Time deposits (CDB/RDB-preset) - Daily return (percentage) \tab 14 \cr
 \bold{'indprod'} \tab Prodcution Indicators (2012=100) - General	\tab 21859 \cr
 \bold{'selic'} \tab Interest rate - Selic accumulated in the month in annual terms (basis 252) \tab 4189 \cr
 \bold{'unemp'} \tab Open unemployment rate - by metropolitan region - Brasil (weekly) \tab 10777\cr
 \bold{'vargdp'} \tab GDP - real percentage change in the year \tab 7326 
}
}
\author{
Talitha Speranza \email{talitha.speranza@fgv.br}
}

