% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.series.R
\name{get.series}
\alias{get.series}
\title{Get a complete time series from a BETS database}
\usage{
get.series(code, from = "", to = "", data.frame = FALSE,
  frequency = NULL)
}
\arguments{
\item{code}{A \code{character}. The unique code that references the time series. This code can be obtained by using the \code{\link{BETSsearch}} function.}

\item{from}{A \code{character} or a \code{Data} object. Starting date of the time series (format YYYY-MM-DD).}

\item{to}{A \code{character} or a \code{Data} object. Ending date of the time series (format YYYY-MM-DD).}

\item{data.frame}{A \code{boolean}. True if you want the output to be a data frame. True to \code{ts} output.}

\item{frequency}{An \code{integer}. The frequency of the time series. It is not needed. It is going to be used only if the metadata for the series is corrupted.}
}
\description{
Extracts a complete time series from either the Central Bank of Brazil (BCB), the Brazilian Institute of Geography and Statistics (IBGE) or the Brazilian Institute of Economics (FGV/IBRE).
}
\keyword{get}
