% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FINAL_FUNCTIONS_t_test.R
\name{t.test.BFF}
\alias{t.test.BFF}
\title{t.test.BFF}
\usage{
\method{t.test}{BFF}(
  t_stat,
  n = NULL,
  df = NULL,
  one_sample = TRUE,
  n1 = NULL,
  n2 = NULL,
  savename = NULL,
  r = 1,
  tau2 = NULL,
  save = TRUE,
  xlab = NULL,
  ylab = NULL,
  main = NULL
)
}
\arguments{
\item{t_stat}{T statistic}

\item{n}{sample size (if one sample test)}

\item{df}{degrees of freedom}

\item{one_sample}{is test one sided? Default is TRUE}

\item{n1}{sample size of group one for two sample test}

\item{n2}{sample size of group two for two sample test}

\item{savename}{optional, filename for saving the pdf of the final plot}

\item{r}{r value}

\item{tau2}{tau2 values}

\item{save}{should a copy of the plot be saved?}

\item{xlab}{optional, x label for plot}

\item{ylab}{optional, y label for plot}

\item{main}{optional, main label for plot}
}
\value{
Returns Bayes factor function results
 \tabular{ll}{
   \code{BFF} \tab Bayes Factor Function values \cr
   \tab \cr
   \code{effect_size} \tab Effect sizes tested (seq(0, 1, by = 0.01)) \cr
   \tab \cr
   \code{BFF_max_RMSE} \tab Maximum BFF value \cr
   \tab \cr
   \code{max_RMSE} \tab Effect size that maximizes BFF\cr
   \tab \cr
   \code{tau2} \tab tau^2 values tested\cr
}
}
\description{
t.test.BFF constructs BFFs based on the t test. BFFs depend on hyperparameters r and tau^2 which determine the shape and scale of the prior distributions which define the alternative hypotheses.
By setting r > 1, we use higher-order moments for replicated studies. Fractional moments are set with r > 1 and r not an integer.
All results are on the log scale.
Plot saved to working directory unless a full path is specified in the 'savename' variable of the function.
}
\examples{
tBFF = t.test.BFF(t_stat = 2.5, n = 50, df = 49, save = FALSE)
t.test.BFF(t_stat = 2.5, n1 = 50, n2 = 40, df = 88, save = FALSE, one_sample = FALSE)
t.test.BFF(t_stat = 2.5, n = 50, r = 2, df = 49, save = FALSE)
t.test.BFF(t_stat = 2.5, r = 2, n1 = 50, n2 = 30, df = 78, one_sample = FALSE, save = FALSE)
t.test.BFF(t_stat = 2.5, n = 50, r = 2.5, df = 49, save = FALSE)
t.test.BFF(t_stat=2.5, r = 2.5, n1 = 50, n2 = 30, df = 78, one_sample = FALSE, save=FALSE)
tBFF$BFF_max_RMSE   # maximum BFF value
tBFF$max_RMSE       # effect size which maximizes the BFF value

}
