% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BGData.R
\docType{class}
\name{BGData-class}
\alias{BGData-class}
\alias{BGData}
\title{An S4 Class to Represent Phenotype and Genotype Data.}
\description{
This class is inspired by the phenotype/genotype file format .raw and its
binary companion (also known as .bed) of
\href{https://www.cog-genomics.org/plink2}{PLINK}. It is used by several
functions of this package such as \code{\link[=GWAS]{GWAS()}} for performing a Genome Wide
Association Study or \code{\link[=getG]{getG()}} for calculating a genomic relationship matrix.
}
\details{
There are several ways to create an instance of this class:
\itemize{
\item from arbitrary phenotype/genotype data using one of the constructors
\code{[BGData(...)][initialize,BGData-method]} or \code{[new("BGData", ...)][initialize,BGData-method]}.
\item from a BED file using \code{\link[=as.BGData]{as.BGData()}}.
\item from a previously saved \linkS4class{BGData} object using \code{\link[=load.BGData]{load.BGData()}}.
\item from multiple files (even a mixture of different file types) using
\link[LinkedMatrix:LinkedMatrix-class]{LinkedMatrix::LinkedMatrix}.
\item from a .raw file (or a .ped-like file) using \code{\link[=readRAW]{readRAW()}},
\code{\link[=readRAW_matrix]{readRAW_matrix()}}, or \code{\link[=readRAW_big.matrix]{readRAW_big.matrix()}}.
}

A .ped file can be recoded to a .raw file in
\href{https://www.cog-genomics.org/plink2}{PLINK} using \code{plink --file myfile --recodeA}, or converted to a BED file using \code{plink --file myfile --make-bed}. Conversely, a BED file can be transformed back to a .ped file
using \code{plink --bfile myfile --recode} or to a .raw file using \code{plink --bfile myfile --recodeA} without losing information.
}
\section{Slots}{

\describe{
\item{\code{geno}}{A \linkS4class{geno} object that contains genotypes. \linkS4class{geno} is a
class union of several matrix-like types, many of them suitable for very
large datasets. Currently supported are \link[LinkedMatrix:LinkedMatrix-class]{LinkedMatrix::LinkedMatrix},
\link[BEDMatrix:BEDMatrix-class]{BEDMatrix::BEDMatrix}, \link[bigmemory:big.matrix-class]{bigmemory::big.matrix}, \code{ff_matrix},
and \code{matrix}.}

\item{\code{pheno}}{A \code{data.frame} that contains phenotypes.}

\item{\code{map}}{A \code{data.frame} that contains a genetic map.}
}}

\examples{
X <- matrix(data = rnorm(100), nrow = 10, ncol = 10)
Y <- data.frame(y = runif(10))
MAP <- data.frame(means = colMeans(X), freqNA = colMeans(is.na(X)))
DATA <- BGData(geno = X, pheno = Y, map = MAP)

dim(DATA@geno)
head(DATA@pheno)
head(DATA@map)
}
