% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bma_posterior.R
\name{bma_posterior}
\alias{bma_posterior}
\title{Bayesian Model Averaged Posterior Distribution}
\usage{
bma_posterior(object, param = "pcor", iter = 5000, progress = TRUE)
}
\arguments{
\item{object}{An object of class \code{ggm_search}}

\item{param}{Character string. What parameter should be computed ? The default is
\code{param = "pcor"} which provides the partial correlations. The other
option is the precision matrix (i.e., \code{precision}).}

\item{iter}{Number of iterations (posterior samples; defaults to 5000).}

\item{progress}{Logical. Should a progress bar be included (defaults to \code{TRUE}) ?}
}
\value{
\itemize{

\item \code{bma_mean} The mean of the partial correlation or precision matrix
                      (\code{p} by \code{p} matrix).

\item \code{samples} 3d array of dimensions \code{p} by \code{p} by \code{iter}
including the samples partial correlation or precision matrices.

}
}
\description{
Draw samples from the posterior distribution according to the
             most probable graphs (weighted by their respective posterior model probabilities)
}
\details{
This approach is based on the "direct sampler" described in
\insertCite{@page 122, section 2.4,  @lenkoski2013direct;textual}{BGGM}. In this case,
the posterior is sampled according to the posterior probabilities
for the top ranking graphs.
}
\examples{
\donttest{
# data
Y <- ptsd

# fit model
fit <- ggm_search(Y)

# bma
bma <- bma_posterior(fit, iter = 100)

}

}
\references{
\insertAllCited{}
}
