% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictability.R
\name{summary.predictability}
\alias{summary.predictability}
\title{Summary Method for \code{predictability} Objects}
\usage{
\method{summary}{predictability}(object, cred = 0.95, ...)
}
\arguments{
\item{object}{An object of class \code{predictability}.}

\item{cred}{Numeric. The credible interval width for summarizing the posterior
distributions (defaults to 0.95; must be between 0 and 1).}

\item{...}{Currently ignored}
}
\description{
Summary Method for \code{predictability} Objects
}
\examples{
\donttest{
Y <- ptsd[,1:5]

fit <- explore(Y, iter = 250,
               progress = FALSE)

r2 <- predictability(fit, iter = 250,
                     progress = FALSE)

summary(r2)

}

}
