% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BeMRes.R
\name{BeMRes}
\alias{BeMRes}
\title{Markov Beta Model}
\usage{
BeMRes(
  times,
  delta = rep(1, length(times)),
  alpha = rep(1e-04, K),
  beta = rep(1e-04, K),
  c.r = rep(0, K - 1),
  a.eps = 0.1,
  b.eps = 0.1,
  type.c = 4,
  epsilon = 1,
  iterations = 2000,
  burn.in = floor(iterations * 0.2),
  thinning = 5,
  printtime = TRUE
)
}
\arguments{
\item{times}{Numeric positive vector. Failure times.}

\item{delta}{Logical vector. Status indicator. \code{TRUE} (1) indicates
exact lifetime is known, \code{FALSE} (0) indicates that the corresponding
failure time is right censored.}

\item{alpha}{Nonnegative vector. Small entries are recommended in order to
specify a non-informative prior distribution.}

\item{beta}{Nonnegative vector. Small entries are recommended in order to
specify a non-informative prior distribution.}

\item{c.r}{Nonnegative vector. The higher the entries, the higher the
correlation of two consecutive failure times.}

\item{a.eps}{Numeric. Shape parameter for the prior gamma distribution of
epsilon when \code{type.c = 4}.}

\item{b.eps}{Numeric. Scale parameter for the prior gamma distribution of
epsilon when \code{type.c = 4}.}

\item{type.c}{Integer. 1=defines \code{c.r} as a zero-entry vector; 2=lets
the user define \code{c.r} freely; 3=assigns \code{c.r} an
exponential prior distribution with mean \code{epsilon}; 4=assigns \code{c.r} 
an exponential hierarchical distribution with mean \code{epsilon} which in turn has a
a Ga(a.eps, b.eps) distribution.}

\item{epsilon}{Double. Mean of the exponential distribution assigned to
\code{c.r}}

\item{iterations}{Integer. Number of iterations including the \code{burn.in}
and \code{thining} to be computed for the Markov chain.}

\item{burn.in}{Integer. Length of the burn-in period for the Markov chain.}

\item{thinning}{Integer. Factor by which the chain will be thinned. Thinning
the Markov chain is to reduces autocorrelation.}

\item{printtime}{Logical. If \code{TRUE}, prints out the execution time.}
}
\description{
Posterior inference for the Bayesian non-parametric Markov beta model for discrete
survival times.
}
\details{
Computes the Gibbs sampler given by the full conditional distributions of u
and Pi (Nieto-Barajas & Walker, 2002) and arranges the resulting Markov
chain into a tibble which can be used to obtain posterior summaries.
}
\note{
It is recommended to verify chain's stationarity. This can be done by
checking each partition element individually. See \link{BePlotDiag}.
}
\examples{



## Simulations may be time intensive. Be patient.

## Example 1
#  data(psych)
#  timesP <- psych$time
#  deltaP <- psych$death
#  BEX1 <- BeMRes(timesP, deltaP, iterations = 3000, burn.in = 300, thinning = 1)

## Example 2
#  data(gehan)
#  timesG <- gehan$time[gehan$treat == "control"]
#  deltaG <- gehan$cens[gehan$treat == "control"]
#  BEX2 <- BeMRes(timesG, deltaG, type.c = 2, c.r = rep(50, 22))



}
\references{
- Nieto-Barajas, L. E. & Walker, S. G. (2002). Markov beta and
gamma processes for modelling hazard rates. \emph{Scandinavian Journal of
Statistics} \strong{29}: 413-424.
}
\seealso{
\link{BePlotDiag}, \link{BePloth}
}
