% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CCuMRes.R
\name{CCuMRes}
\alias{CCuMRes}
\title{Bayesian Semiparametric Cure Rate Model with an Unknown Threshold and
Covariate Information}
\usage{
CCuMRes(
  data,
  covs.x = names(data)[seq.int(3, ncol(data))],
  covs.y = names(data)[seq.int(3, ncol(data))],
  type.t = 3,
  K = 50,
  utao = NULL,
  alpha = rep(0.01, K),
  beta = rep(0.01, K),
  c.r = rep(0, K - 1),
  c.nu = 1,
  var.theta.str = 25,
  var.delta.str = 25,
  var.theta.ini = 100,
  var.delta.ini = 100,
  type.c = 4,
  a.eps = 0.1,
  b.eps = 0.1,
  epsilon = 1,
  iterations = 5000,
  burn.in = floor(iterations * 0.2),
  thinning = 3,
  printtime = TRUE
)
}
\arguments{
\item{data}{Double tibble. Contains failure times in the first column,
status indicator in the second, and, from the third to the last column, the
covariate(s).}

\item{covs.x}{Character. Names of covariables to be part of the
multiplicative part of the hazard}

\item{covs.y}{Character. Names of covariables to determine the cure
threshold por each patient.}

\item{type.t}{Integer. 1=computes uniformly-dense intervals; 2=
partition arbitrarily defined by the user with parameter utao and 3=same length intervals.}

\item{K}{Integer. Partition length for the hazard function.}

\item{utao}{vector. Partition specified by the user when type.t = 2. The first value of 
the vector has to be 0 and the last one the maximum observed time, either censored or uncensored.}

\item{alpha}{Nonnegative entry vector. Small entries are recommended in
order to specify a non-informative prior distribution.}

\item{beta}{Nonnegative entry vector. Small entries are recommended in order
to specify a non-informative prior distribution.}

\item{c.r}{Nonnegative vector. The higher the entries, the higher the correlation of two consective intervals.}

\item{c.nu}{Tuning parameter for the proposal distribution for c. 
Only when \code{type.c} is 3 or 4.}

\item{var.theta.str}{Double. Variance of the proposal normal distribution
for theta in the Metropolis-Hastings step.}

\item{var.delta.str}{Double. Variance of the proposal normal distribution
for delta in the Metropolis-Hastings step.}

\item{var.theta.ini}{Double. Variance of the prior normal distribution for theta.}

\item{var.delta.ini}{Double. Variance of the prior normal distribution for delta.
from the acceptance ratio in the Metropolis-Hastings algorithm for delta*.}

\item{type.c}{1=defines \code{c.r} as a zero-entry vector; 2=lets the user
define \code{c.r} freely; 3=assigns \code{c.r} an exponential prior
distribution with mean 1; 4=assigns \code{c.r} an exponential hierarchical 
distribution with mean \code{epsilon} which in turn has a Ga(a.eps, b.eps)
distribution.}

\item{a.eps}{Double. Shape parameter for the prior gamma distribution of
epsilon when \code{type.c = 4}.}

\item{b.eps}{Double. Scale parameter for the prior gamma distribution of
epsilon when \code{type.c = 4}.}

\item{epsilon}{Double. Mean of the exponencial distribution assigned to
\code{c.r} when \code{type.c = 3}.}

\item{iterations}{Integer. Number of iterations including the \code{burn.in}
to be computed for the Markov chain.}

\item{burn.in}{Integer. Length of the burn-in period for the Markov chain.}

\item{thinning}{Integer. Factor by which the chain will be thinned. Thinning
the Markov chain reduces autocorrelation.}

\item{printtime}{Logical. If \code{TRUE}, prints out the execution time.}
}
\description{
Posterior inference for the bayesian semiparmetric cure rate model with
covariates in survival analysis.
}
\details{
Computes the Gibbs sampler with the full conditional distributions of
all model parameters (Nieto-Barajas & Yin, 2008) and arranges the resulting Markov
chain into a tibble which can be used to obtain posterior summaries. Prior
distributions for the regression coefficients Theta and Delta are assumend
independent normals with zero mean and variance \code{var.theta.ini},
\code{var.delta.ini}, respectively.
}
\note{
It is recommended to verify chain's stationarity. This can be done by
checking each element individually. See \code{\link{CCuPlotDiag}}.
}
\examples{



# data(BMTKleinbook)
    # res <- CCuMRes(BMTKleinbook, covs.x = c("tTransplant","hodgkin","karnofsky","waiting"),
    #                covs.y = c("tTransplant","hodgkin","karnofsky","waiting"),
    #                        type.t = 2, K = 72, length = 30,
    #                        alpha = rep(2,72), beta = rep(2,72), c.r = rep(50, 71), type.c = 2,
    #                        var.delta.str = .1, var.theta.str = 1,
    #                        var.delta.ini = 100, var.theta.ini = 100,
    #                        iterations = 100, burn.in = 10, thinning = 1)



}
\references{
- Nieto-Barajas, L. E., & Yin, G. (2008). Bayesian
semiparametric cure rate model with an unknown threshold. Scandinavian
Journal of Statistics, 35(3), 540-556.
https://doi.org/10.1111/j.1467-9469.2007.00589.x

- Nieto-barajas, L. E. (2002). Discrete time Markov gamma processes and time
dependent covariates in survival analysis. Statistics, 2-5.
}
\seealso{
\link{CCuPlotDiag}, \link{CCuPloth}
}
