% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGaPloth.R
\name{CGaPloth}
\alias{CGaPloth}
\title{Plots for the Hazard and Survival Funcion Estimates for the Bayesian
non-parametric Markov gamma model with covariates in survival analysis.}
\usage{
CGaPloth(
  M,
  new_obs = NULL,
  type.h = "segment",
  coxSurv = T,
  intervals = T,
  confidence = 0.95,
  summary = FALSE
)
}
\arguments{
\item{M}{tibble. Contains the output generated by \code{CuMRres}.}

\item{new_obs}{tibble. The function calculates the hazard rates and survival
function estimates for specific individuals expressed in a tibble, the names of the
columns have to be the same as the data input.}

\item{type.h}{character. "segment"= use segments to plot hazard rates,
"line" = link hazard rates by a line}

\item{coxSurv}{logical. Add estimated Survival function with the Cox-Model}

\item{intervals}{logical. If TRUE, plots confidence bands for the selected functions including Cox-Model.}

\item{confidence}{Numeric. Confidence level.}

\item{summary}{logical. If \code{TRUE}, a summary for hazard and survival
functions is returned as a tibble.}
}
\value{
\item{SUM.h}{Numeric tibble. Summary for the mean, median, and a
\code{confint / 100} confidence interval for each segment of the hazard
function. If \code{summary = TRUE}} \item{SUM.S}{Numeric tibble. Summary for
the mean, median, and a \code{confint / 100} confidence interval for each
segment of the survival function. If \code{summary = TRUE}}
}
\description{
Plots the resulting hazard function along with the survival function
estimate defined by the Markov gamma process with covariates (Nieto-Barajas,
2003).
}
\details{
This function return plots for the resulting hazard rate as it is computed
by \code{\link{CGaMRes} and the quantile of Tao specified by the user aswell
as an annotation}. In the same plot the credible intervals for both
variables are plotted; The mean of Pi is also annotated. Additionally, it
plots the survival function with their corresponding credible intervals.
}
\examples{



## Simulations may be time intensive. Be patient.

   # ## Example 1
   #  data(leukemiaFZ)
   #  leukemia1 <- leukemiaFZ
   #  leukemia1$wbc <- log(leukemiaFZ$wbc)
   #  CGEX1 <- CGaMRes(data = leukemia1, K = 10, iterations = 100, thinning = 1)
   #  CGaPloth(CGEX1)



}
\references{
- Nieto-Barajas, L. E. (2003). Discrete time Markov gamma
processes and time dependent covariates in survival analysis. \emph{Bulletin
of the International Statistical Institute 54th Session}. Berlin. (CD-ROM).

- Nieto-Barajas, L. E. & Walker, S. G. (2002). Markov beta and gamma
processes for modelling hazard rates. \emph{Scandinavian Journal of
Statistics} \strong{29}: 413-424.
}
\seealso{
\link{CGaMRes},
}
