% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{BIC.bgvar}
\alias{BIC.bgvar}
\title{Bayesian Information Criterion}
\usage{
\method{BIC}{bgvar}(object, ...)
}
\arguments{
\item{object}{an object of class \code{bgvar}.}

\item{...}{additional arguments.}
}
\value{
Returns a numeric value with the corresponding BIC.
}
\description{
Computes the Bayesian information criterion for an object \code{bgvar}.
}
\examples{
\dontshow{
library(BGVAR)
data(eerData)
cN<-c("EA","US","UK")
eerData<-eerData[cN]
W.trade0012<-apply(W.trade0012[cN,cN],2,function(x)x/rowSums(W.trade0012[cN,cN]))
model.ssvs<-bgvar(Data=eerData,W=W.trade0012,plag=1,saves=100,burns=100,prior="SSVS")
BIC(model.ssvs)
}
\donttest{
library(BGVAR)
data(eerData)
model.mn <- bgvar(Data=eerData,W=W.trade0012,plag=2,saves=100,burns=100,prior="MN")
BIC(model.mn)
}
}
\references{
Schwartz, G. E. (1978) \emph{Estimating the dimension of a model.} Annals of Statistics, Vol. 6(2), pp. 461-464.
}
\author{
Maximilian Boeck
}
