% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgvar_main.R
\name{plot.bgvar}
\alias{plot.bgvar}
\title{Plotting function for fitted values}
\usage{
\method{plot}{bgvar}(x, ..., global = TRUE, resp = NULL)
}
\arguments{
\item{x}{an object of class \code{bgvar}.}

\item{...}{additional arguments.}

\item{global}{if \code{TRUE} global fitted values are plotted, otherwise country fitted values.}

\item{resp}{if only a subset of variables or countries should be plotted. If set to default value \code{NULL} all countries/variables are plotted.}
}
\value{
No return value.
}
\description{
Plots the fitted values in red of either the country VARs or the GVAR (default) along with the original data.
}
\examples{
\donttest{
library(BGVAR)
data(eerData)
model.ssvs <- bgvar(Data=eerData,W=W.trade0012,plag=1,saves=100,burns=100,
                    prior="SSVS")
summary(model.ssvs)
plot(model.ssvs, resp="EA")
}
}
