% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgvar-package.R
\docType{data}
\name{monthlyData}
\alias{monthlyData}
\alias{EA.weights}
\alias{OC.weights}
\alias{W}
\title{Monthly EU / G8 countries macroeconomic dataset}
\format{
The data loads three objects \code{monthlyData}, which is a list object of length \code{N+1} (i.e, the number of countries + the ECB country model), \code{W}, which is an \code{N} times \code{N} weight matrix with rowsums summing up to unity and zero elements on its diagonal. The countries are abbreviated using ISO-2 codes. The weight matrix corresponds to average annual input output flows for the \code{N} countries over the period from 2000 to 2014. The data are from the world input output table database (\url{http://www.wiod.org/home}) and are fully described in Timmerman et al. (2015). \code{monthlyData} contains the country data. Per default, variables that should affect all countries (global variables) are treated as endogenous variables in the US country model (\code{poil}, \code{pcom}, \code{vix}). Akin to Georgiadis (2015), interest setting in the euro area is modeled by a Taylor rule that includes ppp-weighted output and prices of euro area countries. The euro area interest rate enters other country models as an additional exogenous variable. For more details, see below:
\itemize{
\item{W.} {\code{N} times \code{N} weight matrix, rowsums equal unity.}
\item{monthlyData} { is a list object of length \code{N} containing \itemize{
\item{\code{y}}{ Industrial production index, in real terms, logarithmic transform and seasonally adjusted.}
\item{\code{p}}{ Harmonized Consumer Price Index (HCPI) for EU member states, for other countries Consumer Price Index. Data in logarithmic transform and seasonally adjusted.}
\item{\code{stir}}{ Short-term interest rate, typically 3 months money market rate.}
\item{\code{EAstir}}{ Short-term interest rate, typically 3 months money market rate (3 months euribor).}
\item{\code{ltir}}{ Long term interest rates, typically 10-year government bond yields.}
\item{\code{er}}{ Real effective exchange rate index, deflated by consumer prices.}
\item{\code{eq}}{ Equity price index, in logarithmic transform.}
\item{\code{poil}}{ Price of oil, seasonally adjusted, in logarithms.}
\item{\code{pcom}}{ Commodity price index, seasonally adjusted, in logarithms.}
\item{\code{vix}}{ Volatility index, in logarithms.}
}}}
}
\usage{
monthlyData
}
\description{
This data set contains monthly observations on industrial production, consumer price indices, short- and long-term interest rates, real effective exchange rates and equity prices. The time period covered is from January 2000 to December 2015 and the country coverage amounts to  28 countries -- roughly corresponding to EU member states + G-8 countries and a country model to model common monetary policy in the euro area.
}
\keyword{datasets}
