% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{avg.pair.cc}
\alias{avg.pair.cc}
\title{Average Pairwise Cross-Sectional Correlations}
\usage{
avg.pair.cc(object, digits=3)
}
\arguments{
\item{object}{Either an object of class \code{bgvar} or residuals of class \code{bgvar.res}.}

\item{digits}{Number of digits that should be used to print output to the console.}
}
\value{
Returns a list with the following elements
\item{\code{data.cor}}{ is a matrix containing in the rows the cross-sections and in the columns the cross-sectional pairwise correlations of the data per variable.}
\item{\code{resid.cor}}{ is a matrix containing in the rows the cross-sections and in the columns the cross-sectional pairwise correlations of the country models' residuals per variable.}
\item{\code{resid.corG}}{ is a matrix containing in the rows the cross-sections and in the columns the cross-sectional pairwise correlations of the global models' residuals per variable. Only available when \code{avg.pair.cc} has been applied to a \code{bgvar.res} object from \code{residuals}.}
\item{\code{data.res}}{ is a summary object showing the number and percentage of correlations <0.1, between 0.1-0.2, 0.2-0.5 and <0.5 per variable of the data.}
\item{\code{res.res}}{ is a summary object showing the number and percentage of correlations <0.1, between 0.1-0.2, 0.2-0.5 and <0.5 per variable of the country models' residuals. This is also what is used by \code{print.bgvar}.}
\item{\code{res.resG}}{ is a summary object showing the number and percentage of correlations <0.1, between 0.1-0.2, 0.2-0.5 and <0.5 per variable of the global models' residuals. Only available when \code{avg.pair.cc} has been applied to a \code{bgvar. res} object from \code{residuals}.}
}
\description{
Computes average pairwise cross-sectional correlations of the data and the country models' residuals.
}
\details{
If used for analyzing the country models' residuals, \code{avg.pair.cc} computes for each country and a given variable, the average cross-sectional correlation (either for the data or for the residuals). In theory, including foreign variables should soak up cross-sectional residual dependence and  correlation of the residuals should be small. Otherwise dynamic analysis, especially using GIRFs, might lead to invalid results. See Dees et al. (2007) for more details.
}
\examples{
\donttest{
library(BGVAR)
data(eerDatasmall)
model.mn <- bgvar(Data=eerDatasmall,W=W.trade0012.small,plag=1,SV=TRUE,
                  draws=100,burnin=100,prior="MN")
avg.pair.cc(model.mn)

res <- residuals(model.mn)
avg.pair.cc(res)
}
}
\references{
Dees, S., Di Mauro F., Pesaran, M. H. and Smith, L. V. (2007) \emph{Exploring the international linkages of the euro area: A global VAR analysis.} Journal of Applied Econometrics, Vol. 22, pp. 1-38.
}
\seealso{
\code{\link{bgvar}} for estimation of a \code{bgvar} object.
\code{\link{residuals}} for calculating the residuals from a \code{bgvar} object and creating a \code{bgvar.res} object.
}
\author{
Martin Feldkircher
}
