% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\alias{plot.bgvar}
\alias{plot.bgvar.resid}
\alias{plot.bgvar.pred}
\alias{plot.bgvar.irf}
\alias{plot.bgvar.fevd}
\title{Graphical Summary of Output Created with \code{bgvar}}
\usage{
\method{plot}{bgvar}(x, ..., resp = NULL, global = TRUE)

\method{plot}{bgvar.resid}(x, ..., resp = NULL, global = TRUE)

\method{plot}{bgvar.pred}(x, ..., resp = NULL, cut = 40, quantiles = c(0.1, 0.16, 0.5, 0.84, 0.9))

\method{plot}{bgvar.irf}(
  x,
  ...,
  resp = NULL,
  shock = 1,
  quantiles = c(0.1, 0.16, 0.5, 0.84, 0.9),
  cumulative = FALSE
)

\method{plot}{bgvar.fevd}(x, ..., resp, k.max = 10)
}
\arguments{
\item{x}{Either an object of class \code{bgvar}, \code{bgvar.res}, \code{bgvar.irf}, \code{bgvar.predict} or \code{bgvar.fevd}.}

\item{...}{Additional arguments; set graphical parameters.}

\item{resp}{Specify either a specific variable, a specific country or a specific variable in a specific country which should be plotted. If set to \code{NULL} all countries is plotted.}

\item{global}{If \code{global=TRUE} global residuals are plotted, otherwise country residuals.}

\item{cut}{Length of series to be plotted before prediction begins.}

\item{quantiles}{Numeric vector with posterior quantiles. Default is set to plot median along with 68\%/80\% confidence intervals.}

\item{shock}{Specify the shock which should be plotted.}

\item{cumulative}{Default is set to \code{FALSE}. If \code{cumulative=TRUE} cumulative impulse response functions are plotted.}

\item{k.max}{plots the k series with the highest for the decomposition of \code{resp}.}
}
\value{
No return value.
}
\description{
Plotting function for fitted values, residuals, predictions, impulse responses and forecast error variance decompositions created with the \code{BGVAR} package.
}
\examples{
\dontshow{
library(BGVAR)
data(testdata)
model.ssvs <- bgvar(Data=testdata,W=W.test,plag=1,draws=100,burnin=100,
                    prior="SSVS",eigen=TRUE)
}
\donttest{
# example for class 'bgvar'
plot(model.ssvs, resp=c("EA.y","US.Dp"))
}
\donttest{
# example for class 'bgvar.resid'
res <- residuals(model.ssvs)
plot(res, resp="EA.y")
}
\donttest{
# example for class 'bgvar.pred'
fcast <- predict(model.ssvs,n.ahead=8)
plot(fcast, resp="y", cut=20)
}
\donttest{
# example for class 'bgvar.irf'
shockinfo <- get_shockinfo("chol")
shockinfo$shock <- "US.stir"; shockinfo$scale <- +1
irf.chol<-irf(model.ssvs, n.ahead=24, shockinfo=shockinfo)
plot(irf.chol, resp="US")
}
\donttest{
# example for class 'bgvar.fevd'
fevd.us=fevd(irf.chol,var.slct=c("US.stir"))
plot(fevd.us, resp="US.stir", k.max=10)
}
}
\author{
Maximilian Boeck, Martin Feldkircher
}
