% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_occurrence_county}
\alias{BIEN_occurrence_county}
\title{Extract species occurrence records by county.}
\usage{
BIEN_occurrence_county(country, state, county, cultivated = FALSE,
  only.new.world = TRUE, print.query = FALSE, all.taxonomy = FALSE,
  native.status = FALSE, observation.type = FALSE,
  political.boundaries = FALSE, ...)
}
\arguments{
\item{country}{A single country or vector of countries.}

\item{state}{A single state or a vector of states.}

\item{county}{A single county or a vector of counties.}

\item{cultivated}{Return cultivated records as well?  Default is FALSE.}

\item{only.new.world}{Return only records from the New World?  Default is true}

\item{print.query}{Should the PostgreSQL query be printed? The default value is FALSE.}

\item{all.taxonomy}{Return all taxonomic information?  This includes the raw data as well as the "scrubbed" data.}

\item{native.status}{Return information on introduction status?  The default value is FALSE. A value of TRUE also returns additional information on introduction status.}

\item{observation.type}{Return information on type of observation (i.e. specimen vs. plot)?  The default value is FALSE.}

\item{political.boundaries}{Return information on political boundaries for an observation? The default value is FALSE.}

\item{...}{Additional arguments passed to BIEN_sql}
}
\value{
Dataframe containing occurrence records for the specified states/provinces.
}
\description{
BIEN_occurrence_county extracts occurrences records for the specified county or counties.
}
\note{
This function requires you supply either 1) a single country with one or more states, or 2) vectors of equal length for each political level.
}
\examples{
\dontrun{
BIEN_occurrence_county("United States","Arizona","Pima")
country_vector<-c("United States","United States")
state_vector<-c("Arizona","Michigan")
county_vector<-c("Pima","Kent")
BIEN_occurrence_county(country=country_vector, state = state_vector, county = county_vector)}
}
\seealso{
Other occurrence functions: \code{\link{BIEN_occurrence_box}},
  \code{\link{BIEN_occurrence_country}},
  \code{\link{BIEN_occurrence_family}},
  \code{\link{BIEN_occurrence_genus}},
  \code{\link{BIEN_occurrence_records_per_species}},
  \code{\link{BIEN_occurrence_shapefile}},
  \code{\link{BIEN_occurrence_species}},
  \code{\link{BIEN_occurrence_state}}
}

